# coding: iso-8859-1

# Classe charge de lister et de faire un require des fichiers prsents
# dans le projet
#
# Author : King Kadelfek / Marc-Antoine Kruzik
#
# v1.8



require "config.rb"
require "FileUtils"



# Charge les scripts suivant l'tat du programme
# Etat OCRA_NONE :        pas de compilation ni d'excution en cours, les scripts sont chargs
# Etat OCRA_COMPILATION : compilation en cours, la liste des scripts est enregistre dans require.txt
# Etat OCRA_EXECUTION :   excution en cours, la liste des scripts est charge depuis le fichier require.txt
def ocra_mode
  if $ocra_mode != nil
    return $ocra_mode
  end

  if ENV["OCRA_EXECUTABLE"] != nil
    # Si le code est en cours de compilation l'excutable est dfini
    return OCRA_EXECUTION
  end
  if defined?(Ocra) == nil
    # Si le code n'est ni en cours de compilation, ni compil, Ocra n'est pas dfini
    return OCRA_NONE
  else
    # Si le code est en cours de compilation l'excutable n'est pas dfini
    return OCRA_COMPILATION
  end
end


case ocra_mode
when OCRA_NONE
  # Pour pouvoir utiliser la couche d'accs au disque et lister les dossiers
  require(File.join(DIR_RUBY, "Array.rb"))
  require(File.join(DIR_RUBY, "Dir.rb"))
  require(File.join(DIR_RUBY, "String.rb"))
  require(File.join(DIR_DATA_ACCESS, "DA.rb"))
  #require(File.join(DIR_DATA_ACCESS, "Archive.rb"))
when OCRA_COMPILATION
  list = []
  list << File.join(DIR_RUBY, "Array.rb")
  list << File.join(DIR_RUBY, "Dir.rb")
  list << File.join(DIR_RUBY, "String.rb")
  list << File.join(DIR_DATA_ACCESS, "DA.rb")
  list << File.join(DIR_DATA_ACCESS, "Virtual_Object.rb")
  list << File.join(DIR_DATA_ACCESS, "Virtual_Dir.rb")
  list << File.join(DIR_DATA_ACCESS, "Virtual_File.rb")
  for path in list
    before = path
    after = File.join(OCRA_TEMP_DIR, File.basename(before))
    FileUtils.cp(before, after)
    require after
  end
end



# Liste tous les fichiers rb d'un rpertoire et de ses sous-rpertoires,
# et l'enregistre dans un fichier nomm require.txt
#
# dir_path : chemin (relatif ou absolu) du rpertoire o commencer le listage
# rcursif. ".", "./", "" ou nil font rfrence au rpertoire courant
#
#
#
# Un fichier "order.txt" peut tre plac dans un dossier. Ce fichier doit
# contenir la liste des lments devant tre chargs dans un certain ordre.
#
# Exemple :
#  dossier_module
#  ma_classe.rb
#
# Les fichiers contenus dans le dossier "dossier_module" seront chargs avant
# ma_classe.rb. Ensuite, les autres fichiers contenus dans le dossier en cours,
# puis les autres dossiers, seront chargs  leur tour.
#
# Il n'y a pas besoin de spcifier la liste de tous les fichiers et dossiers
# prsents dans le dossier pour utiliser order.txt
#

def lister_rb2(dir_path="./")

  require_arr = []

  dir_path = "." if dir_path == "" or dir_path.nil?

  if File.exists?(dir_path) == false
    warn sprintf("%s %s directory %s doesn't exist", __FILE__, __method__, dir_path)
    return require_arr
  end

  

  lister_rb_rec2(dir_path, require_arr)

  return require_arr

end

def require_rb(path)
  req = lister_rb2(path)
  for file in req
    require file
  end
end


# Fonction rcursive appele par lister_rb de require.rb
def lister_rb_rec2(dir_path, require_arr)
  
  
  if File.directory?(dir_path) == false
    return require_arr
  end

  liste_dir, liste_rb = Dir::dirs_files_reg(dir_path, nil, /.*\.rb$/, false, true)
  #p liste_rb

  # On regarde s'il y a un fichier order.txt
  order = File.join(dir_path, "order.txt")
  if File.exist?(order) == true
    # Ouverture du fichier order
    contenu = DA::file_read(order)

    liste_order = contenu.split("\n")
    liste_order.delete("")

    for nom in liste_order
      nom_complet = dir_path.join(nom)
      if File.exist?(nom_complet) == false
        # On affiche un warning
        puts(sprintf("#68 Le fichier %s est introuvable dans le dossier %s.", nom_complet, dir_path))
        next
      end
      nom_absolu = File.realpath(dir_path.join(nom))
      # On regarde si les noms prciss existent


      # On regarde si le noms prciss est celui d'un dossier
      if File.directory?(nom_absolu) == false
        # Si le nom est un fichier
        # On le supprime de la liste des fichiers  traiter
        liste_rb.delete(nom_absolu)
        #p nom_complet
        # On l'ajoute  require
        require_arr << nom_absolu
      else
        # Si le nom est un dossier
        # On le supprime de la liste des dossiers  traiter
        liste_dir.delete(nom_absolu)
        # On relance la fonction sur le dossier prcis
        lister_rb_rec2(nom_absolu, require_arr)
      end

    end


  end

  # On ajoute les noms  require_txt
  for rb in liste_rb
    require_arr << rb
  end

  # On traite les dossiers du rpertoire
  for nom in liste_dir
    nom_complet = nom
    # On relance la fonction sur le dossier prcis
    lister_rb_rec2(nom_complet, require_arr)
  end



end
private :lister_rb_rec2





################################################################################
# OCRA
################################################################################




def check_ocra(require_list)


  ocra = ocra_mode

  case ocra
  when OCRA_NONE
    #p "ocra non defined"

    # On regarde si la compilation a t demande
    # Pour utiliser ce code, il faut crer un raccourci vers le fichier rb principal,
    # puis diter le raccourci (clic droit -> proprits) en ajoutant
    # " -compilation" (sans les guillemets, et attention  l'espace).
    # Exemple : "F:\Projects Netbeans\Compilateur\lib\main.rb" -compilation
    #p ARGV[0]
    if ARGV[0] == "-compilation"
      compiler_exe(MAIN_FILE, require_list)
      #DA::file_copy("Main.exe", "../Main.exe")
      execute_setup("Output")
      puts "Compilation OK"
      exit
    end

  when OCRA_COMPILATION
    #p "ocra compilation"

    require_list = Dir["#{OCRA_TEMP_DIR}/*.rb"]
    
=begin
    reg_up = /^(\.\.\/)+/
    for file_path in require_list
      # On regarde si le fichier est situ en dehors de l'arborescence
      if reg_up === file_path
        file_path_sub = file_path.sub(reg_up, OCRA_TEMP_DIR+"/")
        DA::file_copy_secure(file_path, file_path_sub)
        file_path.replace(file_path_sub)
      end
    end
=end

  when OCRA_EXECUTION
    #p "ocra execution"
    
    # Lecture depuis le fichier txt
    path_require = File.join(get_ocra_dir, OCRA_REQUIRE)
    f = File.open(path_require)
    c = f.read
    f.close

    require_list = c.split("\n")

  end


  # Chargement des scripts
  for file_path in require_list
    puts file_path if $require_show == true
    require file_path
  end

  # On n'excute pas la suite du programme s'il est en compilation
  exit if ocra == OCRA_COMPILATION

  #if ocra == OCRA_EXECUTION
  ressources_copy
  #end

  return ocra
end



  

def compiler_exe(rb, require_list)

  
  # Cration du dossier temporaire
  FileUtils::mkdir(OCRA_TEMP_DIR) if File.exists?(OCRA_TEMP_DIR) == false


  # List all folders
  #folders = Virtual_Dir.folders_from_list(require_list)
  #p folders[1]
  #exit

  for i in 0...require_list.size
    file_path_before = require_list.at(i)
    file_path_after = sprintf("%s/%04d-%s", OCRA_TEMP_DIR, i, File.basename(file_path_before))
    FileUtils.cp(file_path_before, file_path_after)
    require_list[i] = file_path_after

  end


  #p require_list

  DA::file_write(OCRA_REQUIRE, require_list.join("\n"))


  res_list = Dir["Ressources/**/**.*"]
  #p res_list
  #p res_list.size

  ressources = ""
  for res in res_list
    ressources += " '#{res}'"
  end

  #p ressources

  #rb = File.realpath("hello.rb")
  #code = sprintf("ocra 'main.rb' --no-lzma --chdir-first --innosetup 'main.iss'")

  code = sprintf("ocra '%s' '%s' %s --no-lzma --chdir-first --innosetup '%s'",
    File.realpath(rb), OCRA_REQUIRE, ressources, "main.iss")
  #code = sprintf("ocra '%s' '%s' %s --debug-extract ", File.realpath(rb), OCRA_REQUIRE, ressources)
  #code = sprintf("ocra '%s' '%s' %s ", File.realpath(rb), OCRA_REQUIRE, ressources)
  p code
  system code
  puts "setup created"
  
  FileUtils.rm_rf(OCRA_TEMP_DIR)

end


def execute_setup(folder)
  # We extract the program in the folder
  memo = Dir.pwd
  Dir.chdir(folder)
  setup = "mainInstaller.exe"
  code = "#{setup} /silent"
  system code
  Dir.chdir(memo)

  
  folder_exe = folder.join("Executable")
  exe = folder_exe.join("main.exe")
  bin = folder_exe.join("bin")
  lib = folder_exe.join("lib")
  src = folder_exe.join("src")

  winrar = "C:/Program Files/WinRAR/rar.exe"

  name_soft = "DreaMaker_XP-v#{$dmk_version}"
  t = Time.new
  date = sprintf("%d_%d_%d", t.year, t.month, t.day)
  
  exe2 = folder_exe.join("#{name_soft}.exe")
  File.rename(exe, exe2)
  exe = exe2

  folder_releases = "F:/PROGRAMMES/DreaMaker Tout/Release"
  folder_release = folder_releases.join(name_soft)
  folder_release_date = folder_releases.join(date+"-"+name_soft)


  if File.exists?(folder_release)
    FileUtils.rm_rf(folder_release)
  end
  if File.exists?(folder_release_date)
    FileUtils.rm_rf(folder_release_date)
  end
  if File.exists?(folder_releases.join(name_soft+".rar"))
    FileUtils.rm_rf(folder_releases.join(name_soft+".rar"))
  end

  DA::mkdir(folder_release)
  
  txts = Dir[src.join("ressources/*.txt")]

  list = [bin, lib, src, exe]+txts
  DA::copy_into(folder_release, list)
  
  # Winrar
  puts "Winrar"
  memo = Dir.pwd
  Dir.chdir(folder_releases)
  code = sprintf('"%s" -m5 a %s.rar "%s"', winrar, name_soft, name_soft)
  p code
  system code
  Dir.chdir(memo)

  File.rename(folder_release, folder_release_date)

  DA::dir_delete_secure(folder)

end

def is_executable?
  return ocra_mode == OCRA_EXECUTION
end

def get_ocra_dir
  return File.dirname($0)
end

def ressources_copy
  ressources_dir = get_ocra_dir.join("Ressources")
  #pa "ressources", ressources_dir
  look = ressources_dir.join("**/**.*")
  #p look
  ressources = Dir[look]

  for ressource in ressources
    path_apres = ressource.sub(ressources_dir, "./")
    #pa ressource, path_apres
    if File.exists?(path_apres) == false
      DA::file_copy_secure(ressource, path_apres)
    end
  end

end


################################################################################
# RMXP
################################################################################

require "zlib"




def compiler_rmxp(project_dir="./", list_rb=nil)

  # On cre une liste pour tous les scripts  inclure dans Scripts.rxdata
  require_list = []

  # On ajoute  la liste tous les scripts RMXP
  require_list += lister_rb2(DIR_RMXP_SCRIPTS) if DIR_RMXP_SCRIPTS != nil

  # On retire Main.rb de la liste, de faon  pouvoir le mettre  la fin
  main_script = require_list.extract_reg(/Main\.rb/)


  # On ajoute  la liste tous les scripts que l'on souhaite

  require_list += list_rb


  # On remet Main.rb  la fin de la liste pour qu'il soit  la fin de la liste
  # des scripts RMXP, comme d'habitude
  require_list += main_script


  # Le chemin du fichier Scripts
  rxdata = project_dir.join("Data/Scripts.rxdata")
  # Le chemin de l'excutable
  executable = project_dir.join("Game.exe")


  # On remplace le fichier Scripts.rxdata par tous les fichiers rb que l'on a lists
  fabriquer_script(rxdata, require_list)



  # On lance l'excutable
  system '"'+executable+'"'



end


def add_script(list, path_rb, name="")
  #p path_rb
  contenu = DA::file_read(path_rb)
  #0.step(contenu.size, 10){|i|
  #  p i, contenu[i..i+10]
  #  contenu[i..i+10].encode("UTF-8")
  #}


  contenu.gsub!("\n", "\r\n")
  contenu = contenu.encode("UTF-8")
  script = [0, name, Zlib::Deflate.deflate(contenu)]
  list << script
end


# Fabrique un fichier scripts  partir des fichiers ruby lists
def fabriquer_script(path_rxdata, list_files)




  puts "Scripts : #{list_files.size}"
  list_scr = []
  for path in list_files

    indent = 0

    #doc_rmxp(cc)
    name = File.basename(path, ".rb")
    name_indent = " "*indent+name
    add_script(list_scr, path, name_indent)
  end

  DA::marshal_write(path_rxdata, list_scr)

end

